USE V03BYNBMSDB
DECLARE @FACILITY_CODE NVARCHAR(10), @FACILITY_UID UNIQUEIDENTIFIER,  @START_DATE DATETIME
--@START_DATE - INITIAL START DATE
SET @START_DATE = '20110210' 
SET @FACILITY_CODE = 'BYN'
SELECT @FACILITY_UID = E.IDENTIFIER
FROM BMS_EIS.dbo.ENTITY AS E
	INNER JOIN BMS_EIS.dbo.EHL7_ORGANIZATION AS O ON E.PK_ENTITY = O.PFK_ORGANIZATION 
	INNER JOIN BMS_EIS.dbo.EHL7_UID AS F ON E.PK_ENTITY = F.FK_ENTITY AND F.IDENTIFIER_ROOT = 'CODE'
WHERE F.IDENTIFIER_EXTENSION = @FACILITY_CODE AND O.CODE_CODE = 'FAC'

DECLARE @COUNT_BMS_ACTIVE_WL INT, @COUNT_LOCAL_DATABASE_ACTIVE_WL INT, @COUNT_PATIENT_NOT_FOUNT_IN_BMS_EIS INT,
		@COUNT_BMS_REMOVED_WL INT, @COUNT_LOCAL_DATABASE_REMOVED_WL INT

SELECT @COUNT_BMS_ACTIVE_WL = COUNT(*) FROM BMS.dbo.WAITING_LIST as WL
WHERE WL.FACILITY_UID = @FACILITY_UID AND WL.REMOVED_DATE is null

SELECT @COUNT_LOCAL_DATABASE_ACTIVE_WL = COUNT(*) FROM Bed_Control_Waiting WHERE REMOVE_FROM_LIST IS NULL AND EVENT_TIME >= @START_DATE

IF(@COUNT_BMS_ACTIVE_WL = @COUNT_LOCAL_DATABASE_ACTIVE_WL)
	BEGIN
		SELECT 'ACTIVE WAINTIG LIST SUCCESSFULLY IMPORTED'
	END
IF(@COUNT_BMS_ACTIVE_WL <> @COUNT_LOCAL_DATABASE_ACTIVE_WL)
	BEGIN
		SELECT 'IN LOCAL DATABASE (CLS. 3) ARE: ' + CAST(@COUNT_LOCAL_DATABASE_ACTIVE_WL AS NVARCHAR(MAX)) + ' ACTIVE WL'
		SELECT 'IN BMS DATABASE (CLS. 1) ARE: ' + CAST(@COUNT_BMS_ACTIVE_WL AS NVARCHAR(MAX)) + ' ACTIVE WL'
		
		SELECT @COUNT_PATIENT_NOT_FOUNT_IN_BMS_EIS = COUNT(*)
		FROM (
		SELECT LEFT(LTRIM(RTRIM(SSN)),3) + '-' + LEFT(RIGHT(LTRIM(RTRIM(SSN)),6),2) + '-' + RIGHT(LTRIM(RTRIM(SSN)),4) AS SSN
		FROM Bed_Control_Waiting 
		WHERE REMOVE_FROM_LIST IS NULL AND EVENT_TIME >= @START_DATE ) D
		LEFT OUTER JOIN BMS_EIS.dbo.EHL7_UID AS EHL7_UID1 ON EHL7_UID1.IDENTIFIER_EXTENSION = D.SSN AND EHL7_UID1.IDENTIFIER_ROOT ='SSN'  
		WHERE D.SSN IS NULL
		
		SELECT CAST(@COUNT_PATIENT_NOT_FOUNT_IN_BMS_EIS AS NVARCHAR(MAX)) + ' PATIENTS NOT FOUND IN BMS EIS'
		
	END
	
	
SELECT @COUNT_BMS_REMOVED_WL = COUNT(*) FROM BMS.dbo.WAITING_LIST as WL
WHERE WL.FACILITY_UID = @FACILITY_UID AND WL.REMOVED_DATE is NOT null

SELECT @COUNT_LOCAL_DATABASE_REMOVED_WL = COUNT(*) FROM Bed_Control_Waiting WHERE REMOVE_FROM_LIST IS NOT NULL AND EVENT_TIME >= @START_DATE

IF(@COUNT_BMS_REMOVED_WL = @COUNT_LOCAL_DATABASE_REMOVED_WL)
	BEGIN
		SELECT 'REMOVED WAINTIG LIST SUCCESSFULLY IMPORTED'
	END
IF(@COUNT_BMS_REMOVED_WL <> @COUNT_LOCAL_DATABASE_REMOVED_WL)
	BEGIN
		SELECT 'IN LOCAL DATABASE (CLS. 3) ARE: ' + CAST(@COUNT_LOCAL_DATABASE_REMOVED_WL AS NVARCHAR(MAX)) + ' REMOVED WL'
		SELECT 'IN BMS DATABASE  (CLS. 1) ARE: ' + CAST(@COUNT_BMS_REMOVED_WL AS NVARCHAR(MAX)) + ' REMOVED WL'
		
		SET @COUNT_PATIENT_NOT_FOUNT_IN_BMS_EIS = NULL
		SELECT @COUNT_PATIENT_NOT_FOUNT_IN_BMS_EIS = COUNT(*)
		FROM (
		SELECT LEFT(LTRIM(RTRIM(SSN)),3) + '-' + LEFT(RIGHT(LTRIM(RTRIM(SSN)),6),2) + '-' + RIGHT(LTRIM(RTRIM(SSN)),4) AS SSN
		FROM Bed_Control_Waiting 
		WHERE REMOVE_FROM_LIST IS NOT NULL AND EVENT_TIME >= @START_DATE ) D
		LEFT OUTER JOIN BMS_EIS.dbo.EHL7_UID AS EHL7_UID1 ON EHL7_UID1.IDENTIFIER_EXTENSION = D.SSN AND EHL7_UID1.IDENTIFIER_ROOT ='SSN'  
		WHERE D.SSN IS NULL
		
		SELECT CAST(@COUNT_PATIENT_NOT_FOUNT_IN_BMS_EIS AS NVARCHAR(MAX)) + ' PATIENTS NOT FOUND IN BMS EIS'
		
	END
